function [f_vec2,g_vec2,time_vec2,e_vec2,matrix2] = TTSA (fun_f, grad_f_y,grad_f_x, grad_g_y, grad_g_yx,...
    grad_g_yy, param, X_0, Y_0, X_hat_r)
disp('TTSA Algorithm starts');
%------------------------parameter definition------------------------------
maxiter = param.maxiter;

%lower-level parameters
O_indx1_r = param.ind;
a = param.a;
L_g = param.lg;
mu_g = param.mug;
L_g_yy = param.lgyy ;
L_g_xy = param.lgxy;
C_g_xy = param.cg;

%upper-level parameters
L_f_y = param.lfy ;
L_f_x = param.lfx ;
C_f_y = param.cf;

%initialization
x= vec(X_0);
y= vec(Y_0);
[n,m] = size(X_0);
c =  mu_g;
L_y = C_g_xy/mu_g;
L = L_f_x + ((L_f_y* C_g_xy)/mu_g) + C_f_y*((L_g_xy/mu_g)+(L_g_yy*C_g_xy/(mu_g^2)));

alpha =  min(mu_g^2 /(8*L_y*L*(L_g^2)), maxiter^(-3/5)/(4*L_y*L));
beta =   .25 * min(mu_g/(L_g^2), (2* (maxiter^(-2/5)))/mu_g);


tic;
%----------------------------- TTSA algorithm------------------------------
iter = 0;
f_vec2 = [];
g_vec2 = [];
time_vec2 = [];
e_vec2 = [];

while iter <= maxiter
    iter = iter+1;
    h_g = grad_g_y(x,y);
    H = grad_f_y(x,y); 
    p = ceil((L_g/mu_g)*log(iter+1));
    tmax = p;
    i = 0;
    while i<randi(p)
        H = (speye(n*m,n*m) - (c/L_g)* grad_g_yy(y))*H;
        i = i+1;
    end

    h_f = grad_f_x (x,y) - (grad_g_yx*(((tmax* c )/L_g)*H));

 
    y = y - beta*h_g;  % y update
    x = x - alpha*h_f; % x update 

    %-------------------------projection step------------------------------
       
    x = vec(nuclearproj(reshape(x,[n m]),a));
    %----------------------------------------------------------------------
   %normalized error
   e2 = (sum(((x.* O_indx1_r - X_hat_r.* O_indx1_r).^2)))/ (sum((X_hat_r.* O_indx1_r).^2));

   cpu_t2 = toc;
   f_vec2 = [f_vec2;fun_f(x,y)];
   g_vec2 = [g_vec2;norm(grad_g_y(x,y))];
   e_vec2 = [e_vec2;e2];
   time_vec2 = [time_vec2;cpu_t2];
   if cpu_t2>param.maxtime
        break;
   end
end
matrix2 = x;
end
    